LuaJIT FFI GUI Engine (SDL2 + Cairo)

Minimal scaffolding for a small graphic UI engine written in LuaJIT using ffi to call SDL2 and cairo.

Prerequisites
- LuaJIT (luajit)
- SDL2 dev library and runtime (libsdl2)
- Cairo dev library and runtime (libcairo)
- pkg-config (for locating libs at build time)

Quick run (Linux):

Install dependencies (Debian/Ubuntu example):

```
sudo apt install luajit libSDL2-2.0-0 libSDL2-dev libcairo2 libcairo2-dev pkg-config
```

Run the example:

```
cd /home/arkenidar/project/gui
./run.sh
```

Files added
- src/ffi_sdl.lua — minimal SDL2 FFI binding
- src/ffi_cairo.lua — minimal Cairo FFI binding
- src/engine.lua — small engine: window + event loop + Cairo rendering
- main.lua — example entrypoint
- run.sh — convenience runner

Notes
- This is a minimal, educational starting point. For production use you should harden error checks, manage surface formats carefully, and add resource cleanup.
