-- ensure lua can find src modules in current folder
package.path = package.path .. ";./src/?.lua;./?.lua"

local engine = require("engine")

local W, H = 800, 600

-- add a centered button with a click callback (engine will center on resize)
-- counter state
local counter = 0

-- central circular label
local center_btn = { w = 120, h = 120, center = true, label = tostring(counter), radius = 999, shape = "circle", on_click = function() end }
engine.add_button(center_btn)

-- decrement button to the left (ellipsoid)
engine.add_button{ w = 90, h = 56, center = true, offset_x = -160, offset_y = 0, label = "-", radius = 28, shape = "ellipse", on_click = function()
	counter = counter - 1
	center_btn.label = tostring(counter)
end }

-- increment button to the right (ellipsoid)
engine.add_button{ w = 90, h = 56, center = true, offset_x = 160, offset_y = 0, label = "+", radius = 28, shape = "ellipse", on_click = function()
	counter = counter + 1
	center_btn.label = tostring(counter)
end }

engine.run{ title = "LuaJIT FFI GUI (SDL2 + Cairo)", w = W, h = H }
