local ffi = require("ffi")

ffi.cdef[[
typedef struct _cairo cairo_t;
typedef struct _cairo_surface cairo_surface_t;

typedef enum {
  CAIRO_FORMAT_ARGB32 = 0
} cairo_format_t;

cairo_surface_t *cairo_image_surface_create_for_data(unsigned char *data, cairo_format_t format, int width, int height, int stride);
void cairo_surface_destroy(cairo_surface_t *surface);
void cairo_surface_flush(cairo_surface_t *surface);
void cairo_surface_mark_dirty(cairo_surface_t *surface);

cairo_t *cairo_create(cairo_surface_t *surface);
void cairo_destroy(cairo_t *cr);
void cairo_set_source_rgb(cairo_t *cr, double r, double g, double b);
void cairo_set_source_rgba(cairo_t *cr, double r, double g, double b, double a);
void cairo_rectangle(cairo_t *cr, double x, double y, double width, double height);
void cairo_move_to(cairo_t *cr, double x, double y);
void cairo_line_to(cairo_t *cr, double x, double y);
void cairo_arc(cairo_t *cr, double xc, double yc, double radius, double angle1, double angle2);
void cairo_close_path(cairo_t *cr);
void cairo_fill(cairo_t *cr);
void cairo_fill_preserve(cairo_t *cr);
void cairo_set_line_width(cairo_t *cr, double width);
void cairo_stroke(cairo_t *cr);
void cairo_new_path(cairo_t *cr);
void cairo_save(cairo_t *cr);
void cairo_restore(cairo_t *cr);
void cairo_translate(cairo_t *cr, double tx, double ty);
void cairo_scale(cairo_t *cr, double sx, double sy);

void cairo_select_font_face(cairo_t *cr, const char *family, int slant, int weight);
void cairo_set_font_size(cairo_t *cr, double size);
typedef struct { double x_bearing; double y_bearing; double width; double height; double x_advance; double y_advance; } cairo_text_extents_t;
void cairo_text_extents(cairo_t *cr, const char *utf8, cairo_text_extents_t *extents);
void cairo_show_text(cairo_t *cr, const char *utf8);
void cairo_paint(cairo_t *cr);
]]

local C = ffi.load("cairo")

local M = {}
M.C = C
M.ffi = ffi
M.CAIRO_FORMAT_ARGB32 = 0

return M
