local ffi = require("ffi")

ffi.cdef[[
typedef unsigned int Uint32;
typedef unsigned char Uint8;

typedef struct SDL_Window SDL_Window;

typedef struct SDL_PixelFormat SDL_PixelFormat;
typedef struct {
  Uint32 flags;
  SDL_PixelFormat *format;
  int w;
  int h;
  int pitch;
  void *pixels;
  /* we don't need the rest for now */
} SDL_Surface;

typedef union {
  Uint32 type;
  Uint8 padding[56];
} SDL_Event;

int SDL_Init(Uint32 flags);
SDL_Window* SDL_CreateWindow(const char *title, int x, int y, int w, int h, Uint32 flags);
SDL_Surface* SDL_GetWindowSurface(SDL_Window *window);
int SDL_UpdateWindowSurface(SDL_Window *window);
int SDL_PollEvent(SDL_Event *event);
Uint32 SDL_GetMouseState(int *x, int *y);
void SDL_Delay(Uint32 ms);
void SDL_Quit(void);
void SDL_FreeSurface(SDL_Surface* surface);

/* Constants we'll use */
enum { SDL_INIT_VIDEO = 0x00000020 };
enum { SDL_QUIT = 0x100 };
enum { SDL_WINDOW_RESIZABLE = 0x00000020 };
enum { SDL_WINDOWEVENT = 0x200 };
enum { SDL_WINDOWEVENT_RESIZED = 0x0005 };
enum { SDL_MOUSEBUTTONDOWN = 0x401 };
enum { SDL_MOUSEBUTTONUP = 0x402 };
]]

local C = ffi.load("SDL2")

local M = {}
M.C = C
M.ffi = ffi
M.SDL_INIT_VIDEO = 0x00000020
M.SDL_QUIT = 0x100
M.SDL_WINDOW_RESIZABLE = 0x00000020
M.SDL_WINDOWEVENT = 0x200
M.SDL_WINDOWEVENT_RESIZED = 0x0005
M.SDL_MOUSEBUTTONDOWN = 0x401
M.SDL_MOUSEBUTTONUP = 0x402

return M
